/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.resource.crafting.OutputModifier;
import dev.toma.gunsrpg.resource.crafting.SkilledRecipe;
import dev.toma.gunsrpg.resource.util.ResourceUtils;
import dev.toma.gunsrpg.resource.util.conditions.ConditionType;
import dev.toma.gunsrpg.resource.util.conditions.IRecipeCondition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class SkilledRecipeSerializer<R extends SkilledRecipe<?>>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<R> {
    public abstract R createRecipeInstance(ResourceLocation var1, int var2, int var3, NonNullList<Ingredient> var4, ItemStack var5, ItemStack var6, OutputModifier var7, List<IRecipeCondition> var8);

    public final R fromJson(ResourceLocation id, JsonObject data) {
        Map<String, Ingredient> ingredientKeys = SkilledRecipeSerializer.parseIngredientKeys(JSONUtils.func_152754_s((JsonObject)data, (String)"key"));
        String[] optimizedPattern = SkilledRecipeSerializer.minimize(SkilledRecipeSerializer.parsePattern(JSONUtils.func_151214_t((JsonObject)data, (String)"pattern")));
        int width = optimizedPattern[0].length();
        int height = optimizedPattern.length;
        NonNullList<Ingredient> ingredientList = SkilledRecipeSerializer.processPatternAndMatch(optimizedPattern, ingredientKeys, width, height);
        ItemStack output = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)data, (String)"result"), (boolean)true);
        List<IRecipeCondition> required = data.has("requirements") ? ResourceUtils.getConditionsFromJson(JSONUtils.func_151214_t((JsonObject)data, (String)"requirements")) : Collections.emptyList();
        OutputModifier modifier = null;
        ItemStack returningItem = ItemStack.field_190927_a;
        if (data.has("outputModifier")) {
            modifier = OutputModifier.fromJson(JSONUtils.func_152754_s((JsonObject)data, (String)"outputModifier"));
        }
        if (data.has("returningItem")) {
            returningItem = CraftingHelper.getItemStack((JsonObject)JSONUtils.func_152754_s((JsonObject)data, (String)"returningItem"), (boolean)true);
        }
        return this.createRecipeInstance(id, width, height, ingredientList, output, returningItem, modifier, required);
    }

    @Nullable
    public final R fromNetwork(ResourceLocation id, PacketBuffer buffer) {
        List<IRecipeCondition> conditions;
        int conditionCount;
        int width = buffer.func_150792_a();
        int height = buffer.func_150792_a();
        NonNullList ingredients = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
        for (int i = 0; i < ingredients.size(); ++i) {
            ingredients.set(i, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        ItemStack out = buffer.func_150791_c();
        ItemStack returningItem = buffer.func_150791_c();
        boolean outputModifier = buffer.readBoolean();
        OutputModifier modifier = null;
        if (outputModifier) {
            modifier = OutputModifier.decode(buffer);
        }
        if ((conditionCount = buffer.func_150792_a()) == 0) {
            conditions = Collections.emptyList();
        } else {
            conditions = new ArrayList(conditionCount);
            for (int i = 0; i < conditionCount; ++i) {
                conditions.add((IRecipeCondition)ConditionType.fromNetwork(buffer));
            }
        }
        return this.createRecipeInstance(id, width, height, (NonNullList<Ingredient>)ingredients, out, returningItem, modifier, conditions);
    }

    public final void toNetwork(PacketBuffer buffer, R recipe) {
        buffer.func_150787_b(((SkilledRecipe)recipe).getWidth());
        buffer.func_150787_b(((SkilledRecipe)recipe).getHeight());
        for (Ingredient ingredient : ((SkilledRecipe)recipe).func_192400_c()) {
            ingredient.func_199564_a(buffer);
        }
        buffer.func_150788_a(((SkilledRecipe)recipe).func_77571_b());
        buffer.func_150788_a(((SkilledRecipe)recipe).getReturningItem());
        boolean outputModifier = ((SkilledRecipe)recipe).getOutputModifier() != null;
        buffer.writeBoolean(outputModifier);
        if (outputModifier) {
            ((SkilledRecipe)recipe).getOutputModifier().encode(buffer);
        }
        buffer.func_150787_b(((SkilledRecipe)recipe).listConditions().size());
        for (IRecipeCondition craftingCondition : ((SkilledRecipe)recipe).listConditions()) {
            ConditionType.toNetwork(buffer, craftingCondition);
        }
    }

    private static NonNullList<Ingredient> processPatternAndMatch(String[] pattern, Map<String, Ingredient> mappings, int width, int height) {
        NonNullList list = NonNullList.func_191197_a((int)(width * height), (Object)Ingredient.field_193370_a);
        HashSet<String> keySet = new HashSet<String>(mappings.keySet());
        keySet.remove(" ");
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                String key = pattern[y].substring(x, x + 1);
                Ingredient ingredient = mappings.get(key);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + key + "' but it's not defined in the file.");
                }
                keySet.remove(key);
                list.set(x + width * y, (Object)ingredient);
            }
        }
        if (!keySet.isEmpty()) {
            throw new JsonSyntaxException("Found unused key references: " + keySet);
        }
        return list;
    }

    private static Map<String, Ingredient> parseIngredientKeys(JsonObject keyObj) {
        HashMap<String, Ingredient> map = new HashMap<String, Ingredient>();
        for (Map.Entry entry : keyObj.entrySet()) {
            String key = (String)entry.getKey();
            if (key.length() != 1) {
                throw new JsonSyntaxException("Invalid key: '" + key + "' is an invalid syntax (only single character keys are allowed).");
            }
            if (key.equals(" ")) {
                throw new JsonSyntaxException("Invalid key: whitespace is a reserved symbol.");
            }
            map.put(key, Ingredient.func_199802_a((JsonElement)((JsonElement)entry.getValue())));
        }
        map.put(" ", Ingredient.field_193370_a);
        return map;
    }

    private static String[] parsePattern(JsonArray array) {
        String[] pattern = new String[array.size()];
        if (pattern.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum.");
        }
        if (pattern.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed.");
        }
        for (int i = 0; i < pattern.length; ++i) {
            String patternLine = JSONUtils.func_151206_a((JsonElement)array.get(i), (String)("pattern[" + i + "]"));
            if (patternLine.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum.");
            }
            if (i > 0 && pattern[0].length() != patternLine.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            pattern[i] = patternLine;
        }
        return pattern;
    }

    private static String[] minimize(String ... lines) {
        int leftTrim = Integer.MAX_VALUE;
        int rightTrim = 0;
        int k = 0;
        int l = 0;
        for (int index = 0; index < lines.length; ++index) {
            String line = lines[index];
            leftTrim = Math.min(leftTrim, SkilledRecipeSerializer.firstNonWhitespaceChar(line));
            int lastNonWhitespace = SkilledRecipeSerializer.lastNonWhitespaceChar(line);
            rightTrim = Math.max(rightTrim, lastNonWhitespace);
            if (lastNonWhitespace < 0) {
                if (k == index) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (lines.length == l) {
            return new String[0];
        }
        String[] newLines = new String[lines.length - l - k];
        for (int i = 0; i < newLines.length; ++i) {
            newLines[i] = lines[i + k].substring(leftTrim, rightTrim + 1);
        }
        return newLines;
    }

    private static int firstNonWhitespaceChar(String string) {
        int pos;
        for (pos = 0; pos < string.length() && string.charAt(pos) == ' '; ++pos) {
        }
        return pos;
    }

    private static int lastNonWhitespaceChar(String string) {
        int pos;
        for (pos = string.length() - 1; pos >= 0 && string.charAt(pos) == ' '; --pos) {
        }
        return pos;
    }
}

